/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于环境页面
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.18
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_set_funk_card_brightness */
/* exported mc_jungle_time_data */
/* exported mc_analysis_time_data */
/* exported mc_anylsis_get_time_local */
/* exported mc_anylsiis_get_time_local */
/* exported mc_analysis_time_back_data */


/* global mc_sdk_param */
/* global $ */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发接收卡按多功能卡光感自动亮度/定时列表自动亮度
 * 参数:
 *     @param { Promise<String> } Str_order 指令命令
 *     @param { Promise<String> } Str_cmd 设置cmd参数
 *     @param { Promise<String> } str_bright_data 亮度值数据
 *     @param { Promise<string> } str_from_page 界面参数
 *     @param { Promise<string> } str_ctrl_name 主控芯片名称
 *     @param { Promise<object> } obj_local_storage 界面参数数据
 *     @param { Promise<Function> } fun_callback 回调函数
 * 返回：
 *    @return { Promise<Array> } data 数据
 *    @return { Promise<String> } str_error_date 错误码
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.21
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_set_funk_card_brightness(Str_order, Str_cmd, str_bright_data, str_from_page, str_ctrl_name, obj_local_storage, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }

    var str_funk_name = "HW_FUNCCARD_BRIGHTNESS";

    if ("timing" === str_from_page) {
        str_funk_name = "HW_TIMMER_BRIGHTNESS";
    }

    var obj_req = new mc_sdk_param();

    Str_order = "-1:-1:-1:-1:-1";

    obj_req.set_param_clear();
    obj_req.set_cmd(Str_cmd);
    obj_req.set_func(str_funk_name);
    obj_req.set_param_value("Key", Str_order);

    // 只有在发送时设置这些参数 回读只需设置 WORKMODE
    if ("SET_PARAM" === Str_cmd) {
        if (obj_local_storage.b_adjust_list) {
            obj_req.set_attr_val("Key", "BRIGHT_STEP", str_bright_data);
        }


        obj_req.set_attr_val("Key", "CARDTYPE", obj_local_storage.send_card);
        if ("0" === obj_local_storage.send_card) {
            obj_req.set_attr_val("Key", "CHIPNAME", str_ctrl_name);
        }
    }
    if (obj_local_storage.b_adjust_item) {
        var str_workmode = "";

        if (obj_local_storage.b_s_card) {
            str_workmode = "1";
        }
        if (obj_local_storage.b_machine) {
            str_workmode = "2";
        }
        if (obj_local_storage.b_s_card && obj_local_storage.b_machine) {
            str_workmode = "3";
        }

        if (!obj_local_storage.b_s_card && !obj_local_storage.b_machine) {
            str_workmode = "0";
        }

        obj_req.set_attr_val("Key", "WORKMODE", str_workmode);
    }


    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date;
        var data;
        var length = obj_res.get_param_cnt();

        for (var idx = 0; idx < length; idx++) {
            var str_param_name = obj_res.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                str_error_date = obj_res.get_param_value(str_param_name);
            } else {
                data = obj_res.get_attr_val(str_param_name, "BRIGHT_STEP");
            }
        }
        fun_callback(data, str_error_date);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析表格数据(定时亮度调节界面) 并生成分析后的数据
 * 参数:
 *     @param { Promise<string> } ui_data_len 数据的数组长度

 * 返回：
 *    @return { Promise<boolean> } 错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.3.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_jungle_time_data(ui_data_len) {
    if (0 === ui_data_len) {
        return false;
    }

    var ui_time_length = document.getElementsByClassName("mc_time").length;
    var str_value_each = "";

    if (ui_time_length !== ui_data_len) {
        return false;
    }
    for (var idx = 0; idx < ui_time_length; idx++) {
        str_value_each = document.getElementsByClassName("mc_time")[idx].value;

        if (!str_value_each) {
            return idx;
        }
    }

    return true;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析表格数据(定时亮度调节界面) 并生成分析后的数据 ":"换成"."
 * 参数:
 *     @param { Promise<Array> } arr_tbl_list 数据 格式为[[参数1,参数2,参数3],[参数1,参数2,参数3],[参数1,参数2,参数3]] 参数1:排序(1-无穷大) 参数2:时间数据 参数3:接收卡亮度
 *     @param { Promise<Array> } arr_time_list 数据 格式为[[参数1,参数2,参数3],[参数1,参数2,参数3],[参数1,参数2,参数3]] 参数1:排序(1-无穷大) 参数2:时间数据 参数3:接收卡亮度

 * 返回：
 *    @return { Promise<Array> } 解析好的数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.3.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_analysis_time_data(arr_tbl_list, arr_time_list) {
    // 深拷贝
    var str_value_each = "";
    var str_head = "(-1.-1.-1.";
    var str_all = "";
    var str_length = arr_time_list.length;

    for (var idx = 0; idx < str_length; idx++) {
        str_value_each = arr_time_list[idx];

        var arr_data_time = str_value_each.split(":");

        if (2 === arr_data_time.length) {
            str_value_each += ":00";
        }

        str_value_each = str_value_each.replace(/:/g, ".");
        str_value_each = str_head + str_value_each;
        str_value_each += ":";
        str_value_each += arr_tbl_list[idx][2];
        str_value_each += "),";
        str_all += str_value_each;
    }
    str_all = str_all.slice(0, -1);
    return str_all;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析表格数据(定时亮度调节界面)并渲染界面
 * 参数:
 *     @param { Promise<Array> } arr 数据 格式为[[参数],[参数],[参数]] 参数 : 每个time的数值

 * 返回：
 * @return { Promise<boolean> } true/false
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.3.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_anylsis_get_time_local(arr) {
    if (0 === arr.length) {
        return false;
    }
    var obj_html = document.getElementsByClassName("mc_time");
    var arr_data = arr;
    var ui_length = arr_data.length;

    for (var id = 0; id < ui_length; id++) {
        var str_time_val = arr_data[id].toString();

        // 判断当前是否存在数据 不存在一般是在加减情况出现
        if (!str_time_val) {
            continue;
        }
        var arr_temp = str_time_val.split(":");
        var ui_arr_temp_length = arr_temp.length;

        // 添加数据 此时为秒不存在情况
        if (2 === ui_arr_temp_length) {
            str_time_val += ":00";
        }

        // 解析当前数值是否只有单数
        var arr_new_temp = str_time_val.split(":");

        for (var idx = 0; idx < arr_new_temp.length; idx++) {
            if (1 === arr_new_temp[idx].length) {
                arr_new_temp[idx] = "0" + arr_new_temp[idx];
            }
        }
        str_time_val = arr_new_temp[0] + ":" + arr_new_temp[1] + ":" + arr_new_temp[2];

        // 解析数据
        obj_html[id].value = str_time_val;
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析回读的数据 "."换成":"
 * 参数:
 *     @param { Promise<string> } data 回读数据

 * 返回：
 * @return { Promise<Array> } []
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.3.20
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_analysis_time_back_data(data) {
    var arr_data = data.split(",");
    var str_length = arr_data.length;
    var str_each = "";
    var arr_tbl = [];
    var arr_time = [];
    var arr_edit = [];
    var arr_content = [];

    for (var idx = 0; idx < str_length; idx++) {
        var arr_tbl_each = ["", "<input type='time' step='01' class='mc_time' value='' onchange='mc_time_change(this)'/>", "", "<span class='mc_cancel_btn icon-trash' onclick='mc_reduce_port(this)'></span>"];
        var arr_time_each = [];
        // 解析数据

        str_each = arr_data[idx];
        // 去除前后空格
        str_each = str_each.replace(/(^\s*)|(\s*$)/g, "");
        // 排除括号
        if (-1 !== str_each.indexOf("(")) {
            str_each = str_each.slice(1);
        }
        if (-1 !== str_each.indexOf(")")) {
            str_each = str_each.slice(0, -1);
        }
        var arr_each = str_each.split(":");

        // 添加表格
        arr_tbl_each[0] = (idx + 1) + "";
        arr_tbl_each[2] = arr_each[1];
        arr_tbl.push(arr_tbl_each);

        // 添加时间
        // arr_time_each[0] = (idx + 1) + "";
        var arr_time_back_data = arr_each[0].split(".");

        // 校验传回数据
        for (var id = 3; 6 > id; id++) {
            if (1 === arr_time_back_data[id].length) {
                arr_time_back_data[id] = "0" + arr_time_back_data[id];
            }
        }

        arr_time_each = arr_time_back_data[3] + ":" + arr_time_back_data[4] + ":" + arr_time_back_data[5];
        arr_time.push(arr_time_each);

        arr_edit.push([false, false, true]);
        arr_content.push([false, true, false]);
    }

    return [arr_tbl, arr_time, arr_edit, arr_content];
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取发送卡端口 获取发送卡每个端口的备份状态
 * 参数:
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_send_p_backup_status(fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    var arr_s_p = [];

    // 请求对象
    var obj_req_s_p = new mc_sdk_param();

    obj_req_s_p.set_param_clear();
    obj_req_s_p.set_func("HW_SENDCARD_CONNECT");
    obj_req_s_p.set_cmd("GET_PARAM");

    $.post("/access_shell", obj_req_s_p.get_json(), function (result, status) {
        var obj_res_s_p = new mc_sdk_param();

        obj_res_s_p.set_param_clear();
        obj_res_s_p.set_json(result);

        var ui_param_cnt = obj_res_s_p.get_param_cnt();

        for (var idx = 0; idx < ui_param_cnt; idx++) {
            var str_param_name = obj_res_s_p.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            var str_param_val = obj_res_s_p.get_param_value(str_param_name);
            var str_cnt = str_param_val.split(":")[1];

            arr_s_p.push(str_cnt);
        }

        var str_s_id = mc_get_top_data("g_obj_sendcard_data").get_current_sendcard_param() + "";
        var ui_s_p_cnt = Number(arr_s_p[0]);
        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("GET_PARAM");
        obj_req.set_func("HW_SENDCARD_OUTPORT_BACKUP");

        for (var id = 0; id < ui_s_p_cnt; id++) {
            var str_data = "(" + str_s_id + ":" + id + ")";

            obj_req.set_param_value(str_data, "");
        }

        $.post("/access_shell", obj_req.get_json(), function (backup_result, status) {
            var arr_backup_status = [];
            var obj_res = new mc_sdk_param();

            obj_res.set_param_clear();
            obj_res.set_json(backup_result);
            var ui_par_cnt = obj_res.get_param_cnt();

            for (var key = 0; key < ui_par_cnt; key++) {
                var str_par_name = obj_res.get_param_name(key);

                if ("ERROR_CODE" === str_par_name) {
                    continue;
                }
                var str_par_val = obj_res.get_param_value(str_par_name);
                var str_cnt_backup = str_par_val;

                arr_backup_status.push(str_cnt_backup);
            }


            fun_callback(arr_backup_status);
            return;
        });
        return;
    });
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读写HUB输出口使能
 * 参数:
 *    @param {Promise<Array>} arr_backup_status     当前发送卡下的输出口的备份
 *    @param {Promise<function>} fn_callback     回调
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.05
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_backup_port(arr_backup_status, fn_callback) {
    var str_order = mc_get_top_data("g_obj_sendcard_data").get_current_sendcard_param() + ":-1:-1:-1:-1";
    // 指令去前三个
    var arr_order = str_order.split(":");

    var str_s_id = arr_order[0];
    // var str_s_p_id = arr_order[1];
    // var str_h_id = arr_order[2];
    var arr_send_order = [];

    // 先获取发送卡端口
    // 获取发送卡下的端口所有可能存在的hub卡 不区分界面数据
    var ui_s_p_len = arr_backup_status.length;
    // 获取此发送卡下所有端口的hub

    for (var idx = 0; idx < ui_s_p_len; idx++) {
        var str_send_order = str_s_id + ":" + idx;

        arr_send_order.push(str_send_order);
    }
    // 获取hub卡端口数量
    mc_get_hub_p_cnt(arr_send_order, function (obj_data) {
        // 下发备份口
        mc_set_each_backup_port_send(arr_order, "RAM", obj_data, arr_backup_status, function (data) {
            fn_callback(data);
            return;
        });
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取hub卡端口数量
 * 参数:
 *    @param {Promise<string>} arr_order     界面所选的指令
 *    @param {Promise<function>} fn_callback     回调

 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.05
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_hub_p_cnt(arr_order, fn_callback) {
    // 请求对象
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("HW_HUBCARD_CONNECT");
    var ui_order_cnt = arr_order.length;

    for (var idx = 0; idx < ui_order_cnt; idx++) {
        obj_req.set_param_value((idx + ""), arr_order[idx]);
    }

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        var obj_res = new mc_sdk_param();

        obj_res.set_param_clear();
        obj_res.set_json(result);

        var ui_param_cnt = obj_res.get_param_cnt();
        var obj_h_p_cnt = {};


        for (var id = 0; id < ui_param_cnt; id++) {
            var str_param_name = obj_res.get_param_name(id);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            var str_param_val = obj_res.get_param_value(str_param_name);
            var ui_attr_cnt = obj_res.get_attr_cnt(str_param_name);

            for (let id_attr = 0; id_attr < ui_attr_cnt; id_attr++) {
                var str_attr_name = "STATUS";
                var str_attr_val = obj_res.get_attr_val(str_param_name, str_attr_name);
                // 防止hub串联
                var arr_series_hub = str_attr_val.split(",");
                var ui_serier_len = arr_series_hub.length;
                var arr_series_cnt = [];
                var arr_series_hub_name = [];

                for (var idx_series = 0; idx_series < ui_serier_len; idx_series++) {
                    var str_each_series_hub = arr_series_hub[idx_series];
                    var str_name = str_each_series_hub.split(":")[0];
                    var str_cnt = str_each_series_hub.split(":")[1];

                    arr_series_hub_name.push(str_name);
                    arr_series_cnt.push(str_cnt);
                }
                obj_h_p_cnt[str_param_val] = JSON.parse(JSON.stringify({
                    "cnt": "",
                    "name": ""
                }));
                obj_h_p_cnt[str_param_val].cnt = arr_series_cnt;
                obj_h_p_cnt[str_param_val].name = arr_series_hub_name;
            }
        }
        fn_callback(obj_h_p_cnt);
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发备份口参数
 * 参数:
 *    @param {Promise<string>} arr_order     cmd方式
 *    @param {Promise<string>} str_type     下发方式
 *    @param {Promise<object>} obj_data      port数量 key: 指令  val : 数组 [] 存在多个时 表示串联
 *    @param {Promise<Array>} arr_backup_status       当前发送卡输出端口的备份状态
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.04
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_each_backup_port_send(arr_order, str_type, obj_data, arr_backup_status, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback(false);
        return;
    }


    // 筛选界面数据 和硬件实际数据
    var arr_result = mc_handle_page_hw_data(arr_order, obj_data);

    // var arr_hub_name = arr_result[2];

    // if (0 === arr_result[0].length) {
    //     fun_callback(false);
    //     return;
    // }

    // 进一步筛选
    var arr_req = mc_backup_port_filter_data(arr_order, str_type, arr_result, arr_backup_status);
    var str_req = arr_req[0];
    var arr_data = arr_req[1];

    if (!str_req) {
        fun_callback(false);
        return;
    }

    $.post("/access_shell", str_req, function (result, status) {
        fun_callback(arr_data);
        return;
    });
}

// 处理硬件和界面显示
function mc_handle_page_hw_data(arr_order, obj_data) {
    // 界面数据
    var str_s_id = arr_order[0];
    var str_s_p_id = arr_order[1];
    var str_h_id = arr_order[2];

    // var ui_page_s = Number(str_s_id);
    var ui_page_h = Number(str_h_id);

    var str_s_p_page = str_s_id + ":" + str_s_p_id;

    // 下发参数id name_id
    var str_name_id = "";
    // 当前指令下出口的数值
    var ui_curr_h_p_cnt = 0;

    var arr_order_each = [];
    var arr_param_each = [];
    var arr_hub_name = [];

    // eslint-disable-next-line guard-for-in
    for (var key in obj_data) {
        var arr_each_hw_hub_p_cnt = obj_data[key].cnt;
        var arr_each_hw_hub_name = obj_data[key].name;

        if ("-1" !== str_s_p_id) {
            // 页面指定发送卡的某个端口 找硬件是否存在
            if (str_s_p_page === key) {
                // hub卡
                if ("-1" === str_h_id) {
                    // 所有hub卡端口
                    for (var idx_one = 0; idx_one < arr_each_hw_hub_p_cnt.length; idx_one++) {
                        if (!arr_each_hw_hub_p_cnt[idx_one] || !arr_each_hw_hub_name[idx_one]) {
                            // 当前端口卡存 主控:主控端口 表示没有卡
                            str_name_id = key;
                            arr_order_each.push(str_name_id);
                            arr_param_each.push(-1);
                            arr_hub_name.push("");
                            continue;
                        }
                        str_name_id = key + ":" + idx_one;
                        arr_order_each.push(str_name_id);
                        ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[idx_one]);
                        arr_param_each.push(ui_curr_h_p_cnt);
                        arr_hub_name.push(arr_each_hw_hub_name[idx_one]);
                    }
                } else {
                    // 指定某长卡
                    if (!arr_each_hw_hub_p_cnt[ui_page_h]) {
                        continue;
                    }

                    str_name_id = key + ":" + ui_page_h;
                    arr_order_each.push(str_name_id);
                    ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[ui_page_h]);
                    arr_param_each.push(ui_curr_h_p_cnt);
                    arr_hub_name.push(arr_each_hw_hub_name[ui_page_h]);
                }
            }
        } else {
            // 所有发送卡端口
            // hub卡
            if ("-1" === str_h_id) {
                // 先判断是否所有卡数量和

                // 所有卡
                // 所有hub卡端口
                for (var idx_nd = 0; idx_nd < arr_each_hw_hub_p_cnt.length; idx_nd++) {
                    if (!arr_each_hw_hub_p_cnt[idx_nd] || !arr_each_hw_hub_name[idx_nd]) {
                        // 当前端口卡存 主控:主控端口 表示没有卡
                        str_name_id = key;
                        arr_order_each.push(str_name_id);
                        arr_param_each.push(-1);
                        arr_hub_name.push("");
                        continue;
                    }
                    str_name_id = key + ":" + idx_nd;
                    arr_order_each.push(str_name_id);
                    ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[idx_nd]);
                    arr_param_each.push(ui_curr_h_p_cnt);
                    arr_hub_name.push(arr_each_hw_hub_name[idx_nd]);
                }
            } else {
                // 指定某张hub卡端口
                if (arr_each_hw_hub_p_cnt.length <= ui_page_h) {
                    continue;
                }
                str_name_id = key + ":" + ui_page_h;
                arr_order_each.push(str_name_id);
                ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[ui_page_h]);
                arr_param_each.push(ui_curr_h_p_cnt);
                arr_hub_name.push(arr_each_hw_hub_name[ui_page_h]);
            }
        }
    }
    return [arr_order_each, arr_param_each, arr_hub_name];
}


// 进一步筛选 判断是否可发-1
function mc_backup_port_filter_data(arr_order, str_type, arr_result, arr_backup_status) {
    var ui_cnt = arr_result[0].length;

    // 循环所有 筛选备份或非备份状态 得出需要关闭的所有分控
    for (var idx = 0; idx < ui_cnt; idx++) {
        // 排除发送卡端口下没有hub卡或 下的hub卡没有端口
        if (!arr_result[1][idx] || "[OBJECT NUMBER]" !== Object.prototype.toString.call(arr_result[1][idx]).toLocaleUpperCase()) {
            continue;
        }
        // 获取当前所有数据的端口
        var str_p_idx = arr_result[0][idx];

        str_p_idx = str_p_idx.split(":")[1];

        // 获取当前端口所对应端口的备份状态
        var str_backup_corresponing_status = arr_backup_status[Number(str_p_idx)];

        // 判断当前设置的发送
        if (parent.G_B_BACKUP_PORT_SEND) {
            // 发送备份口 关闭其他主口
            if ("0" !== str_backup_corresponing_status) {
                arr_result[1][idx] = mc_handle_port_stop_par(arr_result[1][idx], false);
            }
        } else {
            // 发送主口 关闭备份主口
            if ("1" !== str_backup_corresponing_status) {
                arr_result[1][idx] = mc_handle_port_stop_par(arr_result[1][idx], false);
            }
        }
    }

    // 进一步筛选 若同一个端口下的分控取值未-1  !!!!!暂时这样处理 端口下所有分控开关或关闭
    var arr_finall = [[], [], []];
    var str_prev_s_p = "";
    var arr_handle_order = "";
    var str_hangle_order = "";

    for (var id_fillter_hub = 0; id_fillter_hub < arr_result[0].length; id_fillter_hub++) {
        var str_curr_order = arr_result[0][id_fillter_hub];
        var str_curr_backup_val = arr_result[1][id_fillter_hub];
        var str_curr_chip = arr_result[2][id_fillter_hub];
        var str_curr_s_p = arr_result[0][id_fillter_hub].split(":")[1];

        // 检测是数值
        if ("[object Number]" === Object.prototype.toString.call(str_curr_backup_val)) {
            arr_finall[0].push(str_curr_order);
            arr_finall[1].push(str_curr_backup_val);
            // arr_finall[2].push(str_curr_chip);
            continue;
        }

        if (0 === id_fillter_hub) {
            arr_handle_order = str_curr_order.split(":");
            str_hangle_order = arr_handle_order[0] + ":" + str_curr_s_p + ":" + "-1";

            arr_finall[0].push(str_hangle_order);
            arr_finall[1].push(str_curr_backup_val);
            // arr_finall[2].push(str_curr_chip);
            str_prev_s_p = str_curr_s_p;
            continue;
        }


        if (str_prev_s_p === str_curr_s_p) {
            continue;
        }
        str_prev_s_p = str_curr_s_p;
        arr_handle_order = str_curr_order.split(":");
        str_hangle_order = arr_handle_order[0] + ":" + str_curr_s_p + ":" + "-1";
        arr_finall[0].push(str_hangle_order);
        arr_finall[1].push(str_curr_backup_val);
        // arr_finall[2].push(str_curr_chip);
    }


    var arr_send_order = arr_finall[0];
    var arr_send_param = arr_finall[1];

    // 判断当前是否存在数据可下发
    var b_send_ok = false;

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("HW_HUBCARD_OUTPORT_ENABLE");

    for (var id_order = 0; id_order < arr_send_order.length; id_order++) {
        if (!arr_send_order[id_order] || !arr_send_param[id_order]) {
            continue;
        }
        if ("[object Number]" === Object.prototype.toString.call(arr_send_param[id_order])) {
            continue;
        }
        // 当前是需要开启的话就不用发
        if (-1 !== arr_send_param[id_order].indexOf("1")) {
            continue;
        }
        b_send_ok = true;
        obj_req.set_param_value(arr_send_order[id_order], arr_send_param[id_order]);
        // obj_req.set_attr_val(arr_send_order[id_order], "CHIPNAME", arr_hub_name[id_order]);
        obj_req.set_attr_val(arr_send_order[id_order], "MEMTYPE", str_type);
    }

    if (b_send_ok) {
        return [obj_req.get_json(), arr_finall];
    }

    return [false, ""];
}

// 处理接口val值的格式
function mc_handle_port_stop_par(ui, b_stop) {
    // 是否开启禁用使能
    var str_mark_backup = b_stop ? "1" : "0";
    var str_val = "(";

    if (-1 === ui) {
        ui = 8;
    }

    for (var id = 0; id < ui; id++) {
        str_val += str_mark_backup;
        str_val += ":";
    }
    str_val = str_val.slice(0, -1);
    str_val += ")";
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    开启已关闭的状态
 * 参数:
 *    @param {Promise<Array>} arr_data     下发的数据
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_open_all_backup_stauts(arr_data, fun_callback) {
    if (!arr_data) {
        fun_callback();
        return false;
    }
    var arr_order = arr_data[0];
    var arr_val = arr_data[1];
    var ui_cnt = arr_order.length;

    if (0 === ui_cnt) {
        fun_callback();
        return false;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("HW_HUBCARD_OUTPORT_ENABLE");
    var b_true = false;

    for (var idx = 0; idx < ui_cnt; idx++) {
        var str_par_name = arr_order[idx];
        var str_val = arr_val[idx];

        if ("[object Number]" === Object.prototype.toString.call(str_val)) {
            continue;
        }

        var ui_port_cnt = str_val.slice(1, -1).split(":").length;

        var str_send_val = "(";

        for (var id = 0; id < ui_port_cnt; id++) {
            str_send_val += "1:";
        }

        str_send_val = str_send_val.slice(0, -1);
        str_send_val += ")";

        b_true = true;

        obj_req.set_param_value(str_par_name, str_send_val);
        obj_req.set_attr_val(str_par_name, "MEMTYPE", "RAM");
    }

    if (b_true) {
        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            fun_callback();
            return true;
        });
    }

    return false;
}

// 处理显示界面时间
function mc_jungle_time_local(str_time) {
    var arr_return = [];

    if (!str_time) {
        return arr_return;
    }

    var arr_time = str_time.split(",");
    var ui_cnt = arr_time.length;


    for (var id = 0; id < ui_cnt; id++) {
        var str_each_time = arr_time[id];

        str_each_time = str_each_time.slice(1, -1);
        str_each_time = str_each_time.split(":")[0];
        arr_return.push(str_each_time.replaceAll("?", ":"));
    }
    return arr_return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    初始界面获取硬件/上位机开启状态及数据
 * 参数:
 *    @param {Promise<string>} str_type     获取标识 1:发送卡 / 2:上位机
 *    @param {Promise<string>} str_page     界面识别 环境/定时
 *    @param {Promise<function>} fun_callback     回调
 * 备:
 *      读取数据和状态 ; 状态:1开启/0或无:关闭
 *      定时界面只支持上位机
 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_status(str_type, str_page, fun_callback) {
    var obj_return = {
        data: "",
        status: ""
    };

    var str_funk_name = "HW_FUNCCARD_BRIGHTNESS";

    if ("timing" === str_page) {
        str_funk_name = "HW_TIMMER_BRIGHTNESS";
    }

    var obj_req = new mc_sdk_param();

    var Str_order = "-1:-1:-1:-1:-1";

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func(str_funk_name);
    obj_req.set_param_value("Key", Str_order);

    obj_req.set_attr_val("Key", "BRIGHT_STEP", "");
    obj_req.set_attr_val("Key", "WORKMODE", str_type);

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var length = obj_res.get_param_cnt();

        for (var idx = 0; idx < length; idx++) {
            var str_param_name = obj_res.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            } else {
                obj_return.data = obj_res.get_attr_val(str_param_name, "BRIGHT_STEP");
                obj_return.status = obj_res.get_attr_val(str_param_name, "WORKMODE");
                // 只拿一次
                break;
            }
        }

        fun_callback(obj_return);
        return;
    });
    return;
}

